@extends('layouts.app')

@section('title', 'Análise de Temas - Facebook Video Analytics')

@section('styles')
<style>
    .chart-container {
        position: relative;
        height: 400px;
        margin-bottom: 20px;
    }
    .topic-card {
        transition: transform 0.3s;
        cursor: pointer;
    }
    .topic-card:hover {
        transform: translateY(-5px);
    }
    .topic-card.selected {
        border: 2px solid #3b5998;
        background-color: rgba(59, 89, 152, 0.1);
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>Análise de Temas</h1>
                <div class="btn-group">
                    <a href="{{ route('metrics.index') }}" class="btn btn-outline-primary">
                        <i class="bi bi-speedometer2"></i> Dashboard
                    </a>
                    <a href="{{ route('metrics.compare') }}" class="btn btn-outline-primary">
                        <i class="bi bi-bar-chart"></i> Comparar Vídeos
                    </a>
                    <a href="{{ route('metrics.audience') }}" class="btn btn-outline-primary">
                        <i class="bi bi-people"></i> Análise de Público
                    </a>
                </div>
            </div>
            
            <!-- Filtros -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Filtros</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('metrics.topics') }}" method="GET" class="row g-3">
                        <div class="col-md-4">
                            <label for="page_id" class="form-label">Página</label>
                            <select name="page_id" id="page_id" class="form-select">
                                <option value="">Todas as páginas</option>
                                @foreach($pages as $page)
                                    <option value="{{ $page->id }}" {{ $pageId == $page->id ? 'selected' : '' }}>
                                        {{ $page->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="topic_id" class="form-label">Tema</label>
                            <select name="topic_id" id="topic_id" class="form-select">
                                <option value="">Selecione um tema para análise detalhada</option>
                                @foreach($topics as $topic)
                                    <option value="{{ $topic->id }}" {{ request('topic_id') == $topic->id ? 'selected' : '' }}>
                                        {{ $topic->name }} ({{ $topic->videos_count }} vídeos)
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-filter"></i> Aplicar Filtros
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="row">
                <!-- Temas Populares -->
                <div class="col-md-4">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>Temas Populares</h5>
                        </div>
                        <div class="card-body">
                            <div class="chart-container">
                                <canvas id="topicsChart"></canvas>
                            </div>
                            
                            <div class="list-group mt-4">
                                @foreach($topics as $topic)
                                    <a href="{{ route('metrics.topics', ['topic_id' => $topic->id, 'page_id' => $pageId]) }}" 
                                       class="list-group-item list-group-item-action d-flex justify-content-between align-items-center {{ request('topic_id') == $topic->id ? 'active' : '' }}">
                                        {{ $topic->name }}
                                        <span class="badge bg-primary rounded-pill">{{ $topic->videos_count }}</span>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Análise de Tema Específico -->
                <div class="col-md-8">
                    @if($selectedTopic)
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5>Análise do Tema: {{ $selectedTopic->name }}</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12 mb-4">
                                        <h6>Desempenho ao Longo do Tempo</h6>
                                        <div class="chart-container">
                                            <canvas id="topicPerformanceChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-12">
                                        <h6>Vídeos Relacionados ao Tema</h6>
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>Vídeo</th>
                                                        <th>Publicado em</th>
                                                        <th>Visualizações</th>
                                                        <th>Relevância</th>
                                                        <th>Ações</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($topicVideos as $video)
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center">
                                                                    @if($video->thumbnail_url)
                                                                        <img src="{{ $video->thumbnail_url }}" alt="{{ $video->title }}" class="img-thumbnail me-2" style="width: 60px;">
                                                                    @else
                                                                        <div class="bg-secondary d-flex align-items-center justify-content-center me-2" style="width: 60px; height: 34px;">
                                                                            <i class="bi bi-film text-white"></i>
                                                                        </div>
                                                                    @endif
                                                                    <div>
                                                                        {{ $video->title ?: 'Sem título' }}
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>{{ $video->published_at->format('d/m/Y') }}</td>
                                                            <td>
                                                                @php
                                                                    $viewMetric = $video->metrics->where('metric_name', 'total_video_views')->first() ?? 
                                                                                $video->metrics->where('metric_name', 'views')->first();
                                                                    $views = $viewMetric ? number_format((int)$viewMetric->metric_value) : 'N/A';
                                                                @endphp
                                                                {{ $views }}
                                                            </td>
                                                            <td>
                                                                <div class="progress" style="height: 5px;">
                                                                    <div class="progress-bar" role="progressbar" style="width: {{ $video->pivot->relevance_score * 100 }}%;" aria-valuenow="{{ $video->pivot->relevance_score * 100 }}" aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                {{ number_format($video->pivot->relevance_score * 100, 2) }}%
                                                            </td>
                                                            <td>
                                                                <a href="{{ route('videos.show', $video->id) }}" class="btn btn-sm btn-info">
                                                                    <i class="bi bi-graph-up"></i> Análise
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="card">
                            <div class="card-body">
                                <div class="alert alert-info">
                                    <h4 class="alert-heading">Selecione um tema para análise detalhada</h4>
                                    <p>Escolha um tema na lista à esquerda para visualizar análises detalhadas e vídeos relacionados.</p>
                                </div>
                                
                                <div class="row mt-4">
                                    @foreach($popularTopics as $topic)
                                        <div class="col-md-6 mb-4">
                                            <div class="card topic-card h-100" onclick="window.location='{{ route('metrics.topics', ['topic_id' => $topic->id, 'page_id' => $pageId]) }}'">
                                                <div class="card-body">
                                                    <h5 class="card-title">{{ $topic->name }}</h5>
                                                    <p class="card-text">{{ $topic->description }}</p>
                                                    <div class="d-flex justify-content-between">
                                                        <span class="badge bg-primary">{{ $topic->videos_count }} vídeos</span>
                                                        <a href="{{ route('metrics.topics', ['topic_id' => $topic->id, 'page_id' => $pageId]) }}" class="btn btn-sm btn-outline-primary">
                                                            Ver análise
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Dados para o gráfico de temas populares
        const topicLabels = @json($topics->take(5)->pluck('name')->toArray());
        const topicCounts = @json($topics->take(5)->pluck('videos_count')->toArray());
        
        // Gráfico de temas populares
        const topicsCtx = document.getElementById('topicsChart').getContext('2d');
        new Chart(topicsCtx, {
            type: 'doughnut',
            data: {
                labels: topicLabels,
                datasets: [
                    {
                        data: topicCounts,
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.6)',
                            'rgba(54, 162, 235, 0.6)',
                            'rgba(255, 206, 86, 0.6)',
                            'rgba(75, 192, 192, 0.6)',
                            'rgba(153, 102, 255, 0.6)'
                        ],
                        borderColor: [
                            'rgba(255, 99, 132, 1)',
                            'rgba(54, 162, 235, 1)',
                            'rgba(255, 206, 86, 1)',
                            'rgba(75, 192, 192, 1)',
                            'rgba(153, 102, 255, 1)'
                        ],
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }
        });
        
        // Gráfico de desempenho do tema ao longo do tempo (se um tema estiver selecionado)
        @if($selectedTopic && !empty($topicPerformance))
            const performanceDates = @json(array_keys($topicPerformance));
            const performanceViews = @json(array_values($topicPerformance));
            
            const performanceCtx = document.getElementById('topicPerformanceChart').getContext('2d');
            new Chart(performanceCtx, {
                type: 'line',
                data: {
                    labels: performanceDates,
                    datasets: [
                        {
                            label: 'Visualizações',
                            data: performanceViews,
                            backgroundColor: 'rgba(54, 162, 235, 0.2)',
                            borderColor: 'rgba(54, 162, 235, 1)',
                            borderWidth: 2,
                            tension: 0.3
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,

(Content truncated due to size limit. Use line ranges to read in chunks)