@extends('layouts.app')

@section('title', 'Resultados da Pesquisa')

@section('content')
<div class="mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <h2><i class="fas fa-search me-2"></i>Resultados da Pesquisa</h2>
        <a href="{{ route('video_ads.index') }}" class="btn btn-outline-primary">
            <i class="fas fa-arrow-left me-1"></i>Nova Pesquisa
        </a>
    </div>
    <p class="text-muted">
        Encontrados <strong>{{ $totalResults }}</strong> vídeos criativos
        @if($searchTerm) contendo "<strong>{{ $searchTerm }}</strong>"@endif
        @if($category) na categoria <strong>{{ $category }}</strong>@endif
    </p>
</div>

@if(count($ads) > 0)
    <div class="mb-4">
        <form action="{{ route('video_ads.compare') }}" method="GET" id="compareForm">
            <div class="d-flex justify-content-end mb-3">
                <button type="submit" class="btn btn-success" id="compareBtn" disabled>
                    <i class="fas fa-chart-bar me-1"></i>Comparar Selecionados
                </button>
            </div>
            
            <div class="row">
                @foreach($ads as $ad)
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card h-100 shadow-sm">
                        <div class="card-header bg-light d-flex justify-content-between align-items-center">
                            <div class="form-check">
                                <input class="form-check-input ad-checkbox" type="checkbox" name="ads[]" 
                                    value="{{ $ad['id'] }}" id="ad{{ $ad['id'] }}">
                                <label class="form-check-label" for="ad{{ $ad['id'] }}">
                                    Selecionar
                                </label>
                            </div>
                            <span class="badge bg-primary">{{ $ad['category'] }}</span>
                        </div>
                        <div class="card-body">
                            <h5 class="card-title">{{ $ad['ad_creative_link_title'] }}</h5>
                            <p class="card-text small text-muted">{{ Str::limit($ad['ad_creative_body'], 100) }}</p>
                            
                            <div class="d-flex justify-content-between mb-3">
                                <div class="text-center">
                                    <div class="fs-5 fw-bold text-primary">{{ number_format($ad['views']) }}</div>
                                    <div class="small text-muted">Visualizações</div>
                                </div>
                                <div class="text-center">
                                    <div class="fs-5 fw-bold text-success">{{ number_format($ad['shares']) }}</div>
                                    <div class="small text-muted">Compartilhamentos</div>
                                </div>
                                <div class="text-center">
                                    <div class="fs-5 fw-bold text-danger">{{ number_format($ad['conversions']) }}</div>
                                    <div class="small text-muted">Conversões</div>
                                </div>
                            </div>
                            
                            <p class="card-text small">
                                <i class="fas fa-store me-1"></i>{{ $ad['page_name'] }}
                            </p>
                        </div>
                        <div class="card-footer bg-white border-top-0">
                            <div class="d-grid gap-2">
                                <a href="{{ route('video_ads.show', $ad['id']) }}" class="btn btn-outline-primary">
                                    <i class="fas fa-eye me-1"></i>Ver Detalhes
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </form>
    </div>
@else
    <div class="alert alert-info">
        <i class="fas fa-info-circle me-2"></i>Nenhum vídeo criativo encontrado com os critérios especificados.
        <a href="{{ route('video_ads.index') }}" class="alert-link">Modifique sua pesquisa</a> e tente novamente.
    </div>
@endif

@if(count($ads) > 0)
<div class="card shadow-sm">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="fas fa-chart-pie me-2"></i>Resumo dos Resultados</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <canvas id="categoriesChart" height="250"></canvas>
            </div>
            <div class="col-md-6">
                <canvas id="metricsChart" height="250"></canvas>
            </div>
        </div>
    </div>
</div>
@endif
@endsection

@section('scripts')
<script>
    // Habilitar/desabilitar botão de comparação
    document.addEventListener('DOMContentLoaded', function() {
        const checkboxes = document.querySelectorAll('.ad-checkbox');
        const compareBtn = document.getElementById('compareBtn');
        
        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', updateCompareButton);
        });
        
        function updateCompareButton() {
            const checkedCount = document.querySelectorAll('.ad-checkbox:checked').length;
            compareBtn.disabled = checkedCount < 2;
            
            if (checkedCount >= 2) {
                compareBtn.innerHTML = `<i class="fas fa-chart-bar me-1"></i>Comparar ${checkedCount} Selecionados`;
            } else {
                compareBtn.innerHTML = `<i class="fas fa-chart-bar me-1"></i>Comparar Selecionados`;
            }
        }
    });
    
    @if(count($ads) > 0)
    // Gráficos
    document.addEventListener('DOMContentLoaded', function() {
        // Dados para o gráfico de categorias
        const categories = {};
        @foreach($ads as $ad)
            categories['{{ $ad['category'] }}'] = (categories['{{ $ad['category'] }}'] || 0) + 1;
        @endforeach
        
        // Gráfico de categorias
        const ctxCategories = document.getElementById('categoriesChart').getContext('2d');
        new Chart(ctxCategories, {
            type: 'pie',
            data: {
                labels: Object.keys(categories),
                datasets: [{
                    data: Object.values(categories),
                    backgroundColor: [
                        '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b',
                        '#5a5c69', '#858796', '#6f42c1', '#20c9a6', '#fd7e14'
                    ]
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'right',
                    },
                    title: {
                        display: true,
                        text: 'Distribuição por Categoria'
                    }
                }
            }
        });
        
        // Dados para o gráfico de métricas
        const adsData = @json($ads);
        const labels = adsData.slice(0, 5).map(ad => ad.ad_creative_link_title.substring(0, 15) + '...');
        const views = adsData.slice(0, 5).map(ad => ad.views);
        const shares = adsData.slice(0, 5).map(ad => ad.shares);
        const conversions = adsData.slice(0, 5).map(ad => ad.conversions);
        
        // Gráfico de métricas
        const ctxMetrics = document.getElementById('metricsChart').getContext('2d');
        new Chart(ctxMetrics, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: 'Visualizações',
                        data: views,
                        backgroundColor: '#4e73df'
                    },
                    {
                        label: 'Compartilhamentos',
                        data: shares,
                        backgroundColor: '#1cc88a'
                    },
                    {
                        label: 'Conversões',
                        data: conversions,
                        backgroundColor: '#e74a3b'
                    }
                ]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Top 5 Vídeos - Métricas Principais'
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            maxRotation: 45,
                            minRotation: 45
                        }
                    },
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    });
    @endif
</script>
@endsection
