@extends('layouts.app')

@section('title', 'Análise de Desempenho')

@section('content')
<div class="mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <h2><i class="fas fa-chart-line me-2"></i>Análise de Desempenho</h2>
        <div>
            <a href="{{ route('video_ads.show', $ad['id']) }}" class="btn btn-outline-primary me-2">
                <i class="fas fa-arrow-left me-1"></i>Voltar ao Vídeo
            </a>
            <a href="{{ route('video_ads.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-search me-1"></i>Nova Pesquisa
            </a>
        </div>
    </div>
    <p class="text-muted">
        Análise detalhada de desempenho para o vídeo: <strong>{{ $ad['ad_creative_link_title'] }}</strong>
    </p>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Métricas de Desempenho ao Longo do Tempo</h5>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <canvas id="performanceTimelineChart" height="300"></canvas>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6 class="card-title">Análise de Tendência</h6>
                                <p class="card-text">
                                    @if($ad['performance_metrics']['trend'] > 0)
                                        <i class="fas fa-arrow-up text-success me-1"></i>
                                        O desempenho deste vídeo apresenta uma tendência de <strong class="text-success">crescimento</strong> 
                                        de {{ $ad['performance_metrics']['trend'] }}% nas últimas duas semanas.
                                    @elseif($ad['performance_metrics']['trend'] < 0)
                                        <i class="fas fa-arrow-down text-danger me-1"></i>
                                        O desempenho deste vídeo apresenta uma tendência de <strong class="text-danger">queda</strong> 
                                        de {{ abs($ad['performance_metrics']['trend']) }}% nas últimas duas semanas.
                                    @else
                                        <i class="fas fa-minus text-muted me-1"></i>
                                        O desempenho deste vídeo se manteve <strong>estável</strong> nas últimas duas semanas.
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6 class="card-title">Pico de Desempenho</h6>
                                <p class="card-text">
                                    <i class="fas fa-calendar-check text-primary me-1"></i>
                                    O melhor desempenho foi registrado em <strong>{{ $ad['performance_metrics']['peak_date'] }}</strong>, 
                                    com {{ number_format($ad['performance_metrics']['peak_views']) }} visualizações e 
                                    {{ number_format($ad['performance_metrics']['peak_conversions']) }} conversões.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0">Análise de Conversão</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <canvas id="conversionFunnelChart" height="300"></canvas>
                    </div>
                    <div class="col-md-6">
                        <h6 class="fw-bold mb-3">Funil de Conversão</h6>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead class="table-light">
                                    <tr>
                                        <th>Etapa</th>
                                        <th>Quantidade</th>
                                        <th>Taxa</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Impressões</td>
                                        <td>{{ number_format($ad['views']) }}</td>
                                        <td>100%</td>
                                    </tr>
                                    <tr>
                                        <td>Visualizações Completas</td>
                                        <td>{{ number_format($ad['views'] * $ad['performance_metrics']['completion_rate'] / 100) }}</td>
                                        <td>{{ $ad['performance_metrics']['completion_rate'] }}%</td>
                                    </tr>
                                    <tr>
                                        <td>Cliques</td>
                                        <td>{{ number_format($ad['engagement']['clicks']) }}</td>
                                        <td>{{ round($ad['engagement']['clicks'] / $ad['views'] * 100, 2) }}%</td>
                                    </tr>
                                    <tr>
                                        <td>Conversões</td>
                                        <td>{{ number_format($ad['conversions']) }}</td>
                                        <td>{{ $ad['performance_metrics']['conversion_rate'] }}%</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="alert alert-success mt-3">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Análise:</strong> A taxa de conversão deste vídeo é 
                            @if($ad['performance_metrics']['conversion_rate'] > 2.5)
                                <strong>superior à média</strong> do setor (2.5%).
                            @elseif($ad['performance_metrics']['conversion_rate'] < 2.5)
                                <strong>inferior à média</strong> do setor (2.5%).
                            @else
                                <strong>igual à média</strong> do setor (2.5%).
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">Métricas Principais</h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-6">
                        <div class="card border-left-primary h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">CTR</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $ad['performance_metrics']['ctr'] }}%</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-mouse-pointer fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card border-left-success h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Taxa de Conversão</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $ad['performance_metrics']['conversion_rate'] }}%</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card border-left-info h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">CPC</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">R$ {{ $ad['performance_metrics']['cpc'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card border-left-warning h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">CPM</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">R$ {{ $ad['performance_metrics']['cpm'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-eye fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card border-left-danger h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Taxa de Conclusão</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $ad['performance_metrics']['completion_rate'] }}%</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-video fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card border-left-secondary h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">ROI</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $ad['performance_metrics']['roi'] }}x</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-warning text-white">
                <h5 class="mb-0">Comparação com a Média do Setor</h5>
            </div>
            <div class="card-body">
                <canvas id="sectorComparisonChart" height="300"></canvas>
                
                <div class="alert alert-warning mt-3">
                    <i class="fas fa-lightbulb me-2"></i>
                    <strong>Insight:</strong> Este vídeo criativo tem desempenho 
                    @if($ad['performance_metrics']['sector_comparison'] > 0)
                        <strong>{{ $ad['performance_metrics']['sector_comparison'] }}% acima</strong> da média do setor de varejo.
                    @elseif($ad['performance_metrics']['sector_comparison'] < 0)
                        <strong>{{ abs($ad['performance_metrics']['sector_comparison']) }}% abaixo</strong> da média do setor de varejo.
                    @else
                        <strong>igual</strong> à média do setor de varejo.
                    @endif
                </div>
            </div>
        </div>
        
        <div class="card shadow-sm">
            <div class="card-header bg-dark text-white">
                <h5 class="mb-0">Recomendações</h5>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    @if($ad['performance_metrics']['ctr'] < 2)
                    <li class="list-group-item">
                        <i class="fas fa-exclamation-triangle text-warning me-2"></i>
                        <strong>Melhore o CTR:</strong> Considere ajustar o título e a miniatura do vídeo para aumentar a taxa de cliques.
                    </li>
                    @endif
                    
                    @if($ad['performance_metrics']['completion_rate'] < 50)
                    <li class="list-group-item">
                        <i class="fas fa-exclamation-triangle text-warning me-2"></i>
                        <strong>Aumente a retenção:</strong> O vídeo tem baixa taxa de conclusão. Considere encurtar a duração ou melhorar o conteúdo inicial.
                    </li>
                    @endif
                    
                    @if($ad['performance_metrics']['conversion_rate'] < 2)
                    <li class="list-group-item">
                        <i class="fas fa-exclamation-triangle text-warning me-2"></i>
                        <strong>Melhore as conversões:</strong> Inclua chamadas para ação mais claras e ofertas mais atrativas.
                    </li>
                    @endif
                    
                    @if($ad['performance_metrics']['roi'] < 2)
                    <li class="list-group-item">
                        <i class="fas fa-exclamation-triangle text-warning me-2"></i>
(Content truncated due to size limit. Use line ranges to read in chunks)