# Métodos de Autenticação e Permissões para Aplicação de Análise de Vídeos do Facebook

## Métodos de Autenticação

### Facebook Login

O Facebook Login é o principal método de autenticação para aplicações que precisam acessar dados do Facebook. Ele permite que os usuários façam login na aplicação usando suas credenciais do Facebook e concedam permissões específicas para acessar seus dados.

#### Fluxo de Autenticação

1. **Redirecionamento para o Diálogo de Login**:
   ```
   https://www.facebook.com/v22.0/dialog/oauth?
     client_id={app-id}
     &redirect_uri={redirect-uri}
     &state={state-param}
     &response_type=code
     &scope={permissões-solicitadas}
   ```

2. **Obtenção do Código de Autorização**: Após o usuário autorizar a aplicação, o Facebook redireciona para a URI de redirecionamento com um código de autorização.

3. **Troca do Código por um Token de Acesso**: O código de autorização é trocado por um token de acesso usando uma requisição ao endpoint de token.
   ```
   https://graph.facebook.com/v22.0/oauth/access_token?
     client_id={app-id}
     &redirect_uri={redirect-uri}
     &client_secret={app-secret}
     &code={code}
   ```

4. **Obtenção do Token de Acesso de Página**: Para acessar dados de uma página, é necessário obter um token de acesso de página a partir do token de acesso do usuário.
   ```
   GET /me/accounts
   ```

### Tipos de Tokens de Acesso

1. **Token de Acesso de Usuário (User Access Token)**:
   - Usado para acessar dados do usuário
   - Pode ser de curta duração (expira em aproximadamente 1-2 horas) ou longa duração (expira em aproximadamente 60 dias)
   - Obtido através do fluxo de login do Facebook

2. **Token de Acesso de Página (Page Access Token)**:
   - Usado para acessar dados de uma página específica
   - Necessário para acessar insights de vídeos de uma página
   - Obtido a partir de um token de acesso de usuário com permissões adequadas
   - Pode ser de longa duração se gerado a partir de um token de usuário de longa duração

3. **Token de Acesso de Aplicativo (App Access Token)**:
   - Usado para acessar recursos do aplicativo e não de usuários específicos
   - Gerado usando o ID do aplicativo e o segredo do aplicativo
   - Não pode ser usado para acessar dados de usuários ou páginas

### Obtenção de Token de Longa Duração

Para obter um token de acesso de usuário de longa duração:

```
GET /oauth/access_token?
  grant_type=fb_exchange_token&
  client_id={app-id}&
  client_secret={app-secret}&
  fb_exchange_token={token-de-curta-duração}
```

## Permissões Necessárias

Para uma aplicação de análise de vídeos do Facebook, as seguintes permissões são essenciais:

### 1. `pages_read_engagement`

Esta permissão permite que a aplicação leia conteúdo (posts, fotos, vídeos, eventos) postado pela página, leia dados de seguidores (incluindo nome, PSID) e foto de perfil, e leia metadados e outros insights sobre a página.

**Usos permitidos**:
- Obter conteúdo postado pela página
- Obter nomes, PSIDs e fotos de perfil dos seguidores da página
- Obter metadados sobre a página

### 2. `read_insights`

Esta permissão permite que a aplicação leia os dados de Insights para páginas, aplicativos e domínios web que o usuário possui.

**Usos permitidos**:
- Integrar insights de aplicativo, página ou domínio do Facebook em suas próprias ferramentas de análise

### 3. `pages_show_list`

Esta permissão permite que a aplicação acesse a lista de páginas que uma pessoa gerencia.

**Usos permitidos**:
- Mostrar a uma pessoa a lista de páginas que ela gerencia
- Verificar se uma pessoa gerencia uma página específica

### Permissões Adicionais (Opcionais)

Dependendo das funcionalidades específicas da aplicação, as seguintes permissões podem ser necessárias:

1. **`pages_read_user_content`**: Para ler conteúdo gerado pelo usuário na página, como posts, comentários e avaliações.

2. **`pages_manage_metadata`**: Se a aplicação precisar gerenciar configurações da página.

3. **`pages_manage_posts`**: Se a aplicação precisar criar ou gerenciar posts na página.

## Processo de Aprovação de Permissões

Para usar as permissões listadas acima (exceto `public_profile` e `email`), a aplicação precisa passar pelo processo de revisão de aplicativos do Facebook (App Review).

### Requisitos para Aprovação

1. **Política de Privacidade**: A aplicação deve ter uma política de privacidade válida.

2. **Demonstração de Uso**: É necessário demonstrar como cada permissão será usada na aplicação.

3. **Verificação de Negócio**: Para algumas permissões, pode ser necessária a verificação de negócio.

4. **Perguntas sobre Tratamento de Dados**: Responder a perguntas sobre como os dados serão tratados.

5. **Data Use Checkup**: Completar uma verificação anual de uso de dados.

## Considerações de Segurança

1. **Armazenamento Seguro de Tokens**: Os tokens de acesso devem ser armazenados de forma segura.

2. **HTTPS**: Todas as comunicações com a API do Facebook devem ser feitas via HTTPS.

3. **Validação de Estado**: Usar o parâmetro `state` para prevenir ataques CSRF.

4. **Verificação de Permissões**: Verificar regularmente quais permissões foram concedidas à aplicação, pois os usuários podem revogar permissões a qualquer momento.

5. **Expiração de Permissões**: Se uma permissão não for usada por 90 dias, ela pode expirar e precisará ser concedida novamente.

## Limitações

1. **Granularidade de Permissões**: Os usuários podem conceder apenas um subconjunto das permissões solicitadas.

2. **Permissões para Páginas**: Os usuários podem conceder permissões apenas para páginas específicas que gerenciam, não necessariamente para todas.

3. **Revogação de Permissões**: Os usuários podem revogar permissões a qualquer momento.

4. **Expiração de Tokens**: Os tokens de acesso têm prazos de validade e precisam ser renovados.

## Fluxo de Implementação Recomendado

1. **Registro e Configuração do Aplicativo**:
   - Criar uma conta de desenvolvedor Meta
   - Registrar um aplicativo no painel de desenvolvedores
   - Configurar o Facebook Login

2. **Implementação do Login**:
   - Integrar o botão de login do Facebook ou implementar o fluxo manual
   - Solicitar as permissões necessárias

3. **Gerenciamento de Tokens**:
   - Obter token de acesso de usuário
   - Trocar por token de longa duração
   - Obter token de acesso de página

4. **Verificação de Permissões**:
   - Verificar quais permissões foram concedidas
   - Lidar com permissões recusadas

5. **Acesso aos Dados**:
   - Usar o token de acesso de página para acessar dados de vídeos e insights
   - Implementar cache para reduzir o número de requisições

6. **Renovação de Tokens**:
   - Implementar mecanismo para renovar tokens antes da expiração
   - Lidar com tokens inválidos ou expirados
