@extends('layouts.app')

@section('title', 'Análise de Público - Facebook Video Analytics')

@section('styles')
<style>
    .chart-container {
        position: relative;
        height: 400px;
        margin-bottom: 20px;
    }
    .demographic-chart-container {
        position: relative;
        height: 350px;
    }
    .location-chart-container {
        position: relative;
        height: 350px;
    }
    .audience-card {
        transition: transform 0.3s;
    }
    .audience-card:hover {
        transform: translateY(-5px);
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>Análise de Público</h1>
                <div class="btn-group">
                    <a href="{{ route('metrics.index') }}" class="btn btn-outline-primary">
                        <i class="bi bi-speedometer2"></i> Dashboard
                    </a>
                    <a href="{{ route('metrics.compare') }}" class="btn btn-outline-primary">
                        <i class="bi bi-bar-chart"></i> Comparar Vídeos
                    </a>
                    <a href="{{ route('metrics.topics') }}" class="btn btn-outline-primary">
                        <i class="bi bi-tags"></i> Análise de Temas
                    </a>
                </div>
            </div>
            
            <!-- Filtros -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Filtros</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('metrics.audience') }}" method="GET" class="row g-3">
                        <div class="col-md-4">
                            <label for="page_id" class="form-label">Página</label>
                            <select name="page_id" id="page_id" class="form-select">
                                <option value="">Todas as páginas</option>
                                @foreach($pages as $page)
                                    <option value="{{ $page->id }}" {{ $pageId == $page->id ? 'selected' : '' }}>
                                        {{ $page->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="date_from" class="form-label">Data Inicial</label>
                            <input type="date" class="form-control" id="date_from" name="date_from" value="{{ $dateFrom ? $dateFrom->format('Y-m-d') : '' }}">
                        </div>
                        <div class="col-md-3">
                            <label for="date_to" class="form-label">Data Final</label>
                            <input type="date" class="form-control" id="date_to" name="date_to" value="{{ $dateTo ? $dateTo->format('Y-m-d') : '' }}">
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-filter"></i> Aplicar Filtros
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="row">
                <!-- Gráfico Demográfico -->
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>Distribuição Demográfica</h5>
                        </div>
                        <div class="card-body">
                            <div class="demographic-chart-container">
                                <canvas id="demographicChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Gráfico Geográfico -->
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>Distribuição Geográfica</h5>
                        </div>
                        <div class="card-body">
                            <div class="location-chart-container">
                                <canvas id="locationChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Tabela Demográfica Detalhada -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Dados Demográficos Detalhados</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Segmento</th>
                                    <th>Visualizações</th>
                                    <th>% do Total</th>
                                    <th>Engajamento Médio</th>
                                    <th>Gráfico</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $totalViews = $demographicData->sum('total_views');
                                @endphp
                                
                                @foreach($demographicData as $item)
                                    <tr>
                                        <td>{{ $item->segment_value }}</td>
                                        <td>{{ number_format($item->total_views) }}</td>
                                        <td>{{ number_format(($item->total_views / $totalViews) * 100, 2) }}%</td>
                                        <td>{{ number_format($item->avg_engagement, 2) }}%</td>
                                        <td>
                                            <div class="progress" style="height: 5px; width: 100px;">
                                                <div class="progress-bar" role="progressbar" style="width: {{ ($item->total_views / $totalViews) * 100 }}%;" aria-valuenow="{{ ($item->total_views / $totalViews) * 100 }}" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <!-- Vídeos Populares por Segmento Demográfico -->
            <div class="card">
                <div class="card-header">
                    <h5>Vídeos Mais Populares por Segmento Demográfico</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($popularByDemographic as $segment => $videos)
                            <div class="col-md-6 mb-4">
                                <div class="card audience-card h-100">
                                    <div class="card-header">
                                        <h6 class="mb-0">Segmento: {{ $segment }}</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="list-group">
                                            @foreach($videos as $index => $video)
                                                <a href="{{ route('videos.show', $video->id) }}" class="list-group-item list-group-item-action">
                                                    <div class="d-flex w-100 justify-content-between">
                                                        <h6 class="mb-1">{{ $index + 1 }}. {{ Str::limit($video->title ?: 'Sem título', 30) }}</h6>
                                                        <small>{{ number_format($video->view_count) }} views</small>
                                                    </div>
                                                    <div class="d-flex justify-content-between">
                                                        <small>{{ $video->published_at->format('d/m/Y') }}</small>
                                                        <small>Engajamento: {{ number_format($video->engagement_rate, 2) }}%</small>
                                                    </div>
                                                </a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Dados para o gráfico demográfico
        const demographicLabels = @json($demographicData->pluck('segment_value')->toArray());
        const demographicViews = @json($demographicData->pluck('total_views')->toArray());
        
        // Gráfico demográfico
        const demographicCtx = document.getElementById('demographicChart').getContext('2d');
        new Chart(demographicCtx, {
            type: 'bar',
            data: {
                labels: demographicLabels,
                datasets: [
                    {
                        label: 'Visualizações',
                        data: demographicViews,
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.6)',
                            'rgba(54, 162, 235, 0.6)',
                            'rgba(255, 206, 86, 0.6)',
                            'rgba(75, 192, 192, 0.6)',
                            'rgba(153, 102, 255, 0.6)',
                            'rgba(255, 159, 64, 0.6)',
                            'rgba(199, 199, 199, 0.6)',
                            'rgba(83, 102, 255, 0.6)'
                        ],
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Visualizações'
                        }
                    }
                }
            }
        });
        
        // Dados para o gráfico de localização
        const locationLabels = @json($locationData->pluck('segment_value')->toArray());
        const locationViews = @json($locationData->pluck('total_views')->toArray());
        
        // Gráfico de localização
        const locationCtx = document.getElementById('locationChart').getContext('2d');
        new Chart(locationCtx, {
            type: 'pie',
            data: {
                labels: locationLabels,
                datasets: [
                    {
                        data: locationViews,
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.6)',
                            'rgba(54, 162, 235, 0.6)',
                            'rgba(255, 206, 86, 0.6)',
                            'rgba(75, 192, 192, 0.6)',
                            'rgba(153, 102, 255, 0.6)',
                            'rgba(255, 159, 64, 0.6)',
                            'rgba(199, 199, 199, 0.6)',
                            'rgba(83, 102, 255, 0.6)',
                            'rgba(40, 159, 64, 0.6)',
                            'rgba(210, 199, 199, 0.6)'
                        ],
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right'
                    }
                }
            }
        });
        
        // Processamento de dados para gráfico de idade e gênero
        @if(isset($ageGenderData) && !empty($ageGenderData))
            const ageGenderLabels = [];
            const maleData = [];
            const femaleData = [];
            
            @if(isset($ageGenderData['M']))
                @foreach($ageGenderData['M'] as $ageGroup => $data)
                    ageGenderLabels.push('{{ $ageGroup }}');
                    maleData.push({{ $data['views'] }});
                    
                    @if(isset($ageGenderData['F'][$ageGroup]))
                        femaleData.push({{ $ageGenderData['F'][$ageGroup]['views'] }});
                    @else
                        femaleData.push(0);
                    @endif
                @endforeach
            @endif
            
            // Adicionar gráfico de idade e gênero se houver dados
            if (ageGenderLabels.length > 0) {
                const ageGenderContainer = document.createElement('div');
                ageGenderContainer.className = 'chart-container';
                ageGenderContainer.style.height = '300px';
                
                const ageGenderCanvas = document.createElement('canvas');
                ageGenderCanvas.id = 'ageGenderChart';
                
                ageGenderContainer.appendChild(ageGenderCanvas);
                document.querySelector('.demographic-chart-container').appendChild(ageGenderContainer);
                
                const ageGenderCtx = ageGenderCanvas.getContext('2d');
                new Chart(ageGenderCtx, {
                    type: 'bar',
                    data: {
                        labels: ageGenderLabels,
                        datasets: [
                            {
                                label: 'Masculino',
                                data: maleData,
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Feminino',
                                data: femaleData,
                                backgroundColor: 'rgba(255, 99, 132, 0.6)',
                                borderColor: 'rgba(255, 99, 132, 1)',
                                borderWidth: 1
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                beginAtZero: true,
                                title: {
                                    display: true,
                                    text: 'Visualizações'
                                }
                            }
                        }
                    }
                });
            }
        @endif
    });
</script>
@endsection
