# Pesquisa sobre API do Facebook para Análise de Vídeos

## Visão Geral do Graph API

O Graph API é a principal forma de obter dados da plataforma do Facebook. É uma API baseada em HTTP que os aplicativos podem usar para consultar dados, postar novas histórias, gerenciar anúncios, carregar fotos e realizar uma ampla variedade de outras tarefas.

O Graph API é baseado na ideia de um "grafo social" - uma representação das informações no Facebook. É composto por:
- **Nós**: objetos específicos (como vídeos, páginas, usuários)
- **Arestas**: coleções de objetos em um único objeto
- **Campos**: dados sobre um único objeto ou cada objeto em uma coleção

## API de Insights de Vídeo

A API de Insights de Vídeo do Facebook permite obter métricas agregadas para vídeos em uma Página. É possível obter métricas para Vídeos, Reels e Ad Breaks.

### Endpoint Principal

Para obter insights de um vídeo específico, é necessário fazer uma requisição GET para:

```
GET /<VIDEO_ID>/video_insights?access_token=<PAGE_ACCESS_TOKEN>
```

### Métricas Disponíveis

A API oferece diferentes categorias de métricas:

#### Métricas de Vídeo
- `total_video_views`: Número de vezes que o vídeo foi visualizado por pelo menos 3 segundos
- `total_video_views_unique`: Número de pessoas únicas que visualizaram o vídeo por pelo menos 3 segundos
- `total_video_views_autoplayed`: Número de reproduções automáticas do vídeo por pelo menos 3 segundos
- `total_video_views_clicked_to_play`: Número de vezes que o vídeo foi reproduzido após clique por pelo menos 3 segundos
- `total_video_views_organic`: Número de visualizações orgânicas do vídeo por pelo menos 3 segundos
- `total_video_views_organic_unique`: Número de pessoas únicas que visualizaram o vídeo organicamente
- `total_video_views_paid`: Número de visualizações pagas do vídeo
- `total_video_views_paid_unique`: Número de pessoas únicas que visualizaram o vídeo através de conteúdo pago
- `total_video_views_sound_on`: Número de visualizações com som ativado

#### Métricas de Reels
- `blue_reels_play_count`: Número de vezes que o reel começou a ser reproduzido
- `fb_reels_replay_count`: Número de repetições do reel
- `fb_reels_total_plays`: Número total de reproduções incluindo repetições
- `post_impressions_unique`: Número de pessoas únicas que viram o reel
- `post_video_avg_time_watched`: Tempo médio de visualização em milissegundos
- `post_video_followers`: Número de seguidores obtidos pelo reel
- `post_video_likes_by_reaction_type`: Número de curtidas no reel
- `post_video_retention_graph`: Percentual de retenção em diferentes segmentos do vídeo
- `post_video_social_actions`: Número de comentários e compartilhamentos
- `post_video_view_time`: Tempo total de visualização em milissegundos

#### Métricas de Ad Breaks
- `total_video_ad_break_ad_cpm`: Valor médio pago por anunciantes por 1.000 impressões
- `total_video_ad_break_ad_impressions`: Número de vezes que um anúncio foi exibido durante os intervalos do vídeo
- `total_video_ad_break_earnings`: Estimativa de ganhos com intervalos de anúncios no vídeo
- `creator_monetization_qualified_views`: Número de visualizações do vídeo que receberão pagamento

### Parâmetros de Requisição

| Parâmetro | Descrição |
|-----------|-----------|
| `metric` | Lista de métricas que você deseja receber |
| `period` | Período de agregação (day, week, days_28, month, lifetime, total_over_range) |
| `since` | Limite inferior do intervalo de tempo a considerar |
| `until` | Limite superior do intervalo de tempo a considerar |

## Requisitos de Permissão

Para acessar os dados de insights de vídeo, são necessárias as seguintes permissões:

1. **pages_manage_engagement**: Permissão para gerenciar o engajamento da página
2. **read_insights**: Permissão para ler os insights da página

Além disso, é necessário um token de acesso de página solicitado por uma pessoa que possa executar a tarefa ANALYZE na página.

## Tokens de Acesso

Para acessar a API de Insights de Vídeo, é necessário um **Page Access Token** (Token de Acesso de Página). Este token é usado para ler, escrever e modificar os dados pertencentes a uma Página do Facebook.

Para obter um Page Access Token, é necessário:
1. Obter um User Access Token (Token de Acesso de Usuário)
2. Usar o User Access Token para obter um Page Access Token via Graph API

## Limitações

- Insights para vídeos publicados em grupos ou usuários do Facebook não estão disponíveis
- Um vídeo compartilhado terá um ID de vídeo único para cada página em que foi publicado
- Os dados estão disponíveis apenas para os últimos 2 anos
- Page Insights só está disponível em páginas com 100 ou mais curtidas
- A maioria das métricas é atualizada uma vez a cada 24 horas
- Métricas demográficas (idade, gênero, localização) só são retornadas se houver dados para 100 ou mais pessoas
- Apenas 90 dias de insights podem ser visualizados de uma vez ao usar os parâmetros `since` e `until`
- Várias métricas relacionadas a vídeos só retornam valores precisos se a pessoa que solicita a métrica for o criador da postagem do vídeo da página

## Processo de Aprovação de Aplicativos

Para usar as permissões necessárias, o aplicativo precisa passar por um processo de revisão (App Review). Isso é necessário para todas as permissões, exceto para `email` e `public_profile`, se o aplicativo precisar acessar dados que você não possui ou gerencia.

Além disso, pode ser necessário responder a perguntas sobre o tratamento de dados e completar uma verificação anual de uso de dados (Data Use Checkup).
