<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VideoMetric extends Model
{
    use HasFactory;

    /**
     * Os atributos que são atribuíveis em massa.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'video_id',
        'metric_name',
        'metric_value',
        'period',
        'date_start',
        'date_end',
    ];

    /**
     * Os atributos que devem ser convertidos.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'date_start' => 'datetime',
        'date_end' => 'datetime',
    ];

    /**
     * Obtém o vídeo ao qual a métrica pertence.
     */
    public function video()
    {
        return $this->belongsTo(Video::class);
    }
}
