<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Video extends Model
{
    use HasFactory;

    /**
     * Os atributos que são atribuíveis em massa.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'page_id',
        'facebook_video_id',
        'title',
        'description',
        'thumbnail_url',
        'permalink_url',
        'duration',
        'published_at',
        'video_type',
        'status',
    ];

    /**
     * Os atributos que devem ser convertidos.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'published_at' => 'datetime',
        'duration' => 'integer',
    ];

    /**
     * Obtém a página à qual o vídeo pertence.
     */
    public function page()
    {
        return $this->belongsTo(Page::class);
    }

    /**
     * Obtém as métricas associadas ao vídeo.
     */
    public function metrics()
    {
        return $this->hasMany(VideoMetric::class);
    }

    /**
     * Obtém os segmentos de público associados ao vídeo.
     */
    public function audienceSegments()
    {
        return $this->hasMany(AudienceSegment::class);
    }

    /**
     * Obtém os tópicos associados ao vídeo.
     */
    public function topics()
    {
        return $this->belongsToMany(Topic::class, 'video_topics')
                    ->withPivot('relevance_score')
                    ->withTimestamps();
    }
}
