<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Topic extends Model
{
    use HasFactory;

    /**
     * Os atributos que são atribuíveis em massa.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'description',
    ];

    /**
     * Obtém os vídeos associados ao tópico.
     */
    public function videos()
    {
        return $this->belongsToMany(Video::class, 'video_topics')
                    ->withPivot('relevance_score')
                    ->withTimestamps();
    }
}
