# Facebook Video Analytics - README

## Sobre o Projeto

Facebook Video Analytics é uma aplicação web desenvolvida em Laravel que permite analisar vídeos do Facebook, identificar os mais acessados sobre temas específicos e classificar o público-alvo que mais interagiu com esse conteúdo.

## Funcionalidades Principais

- **Autenticação com Facebook**: Login seguro via OAuth com permissões para acessar páginas e insights
- **Importação de Dados**: Importação automática de páginas e vídeos do Facebook
- **Análise de Métricas**: Dashboard com métricas de engajamento, visualizações e interações
- **Análise de Público**: Segmentação demográfica e geográfica do público
- **Análise de Temas**: Classificação e análise de vídeos por temas
- **Comparação de Vídeos**: Ferramenta para comparar métricas entre diferentes vídeos

## Requisitos Técnicos

- PHP 8.1 ou superior
- MySQL 8.0 ou superior
- Composer
- Node.js e NPM
- Conta de desenvolvedor Meta com aplicativo registrado

## Instalação Local

1. Clone o repositório:
```bash
git clone [URL_DO_REPOSITÓRIO] facebook-video-analytics
cd facebook-video-analytics
```

2. Instale as dependências:
```bash
composer install
npm install
npm run build
```

3. Configure o ambiente:
```bash
cp .env.example .env
php artisan key:generate
```

4. Configure o banco de dados no arquivo `.env`:
```
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=facebook_video_analytics
DB_USERNAME=seu_usuario
DB_PASSWORD=sua_senha
```

5. Configure as credenciais do Facebook no arquivo `.env`:
```
FACEBOOK_CLIENT_ID=seu_app_id
FACEBOOK_CLIENT_SECRET=seu_app_secret
FACEBOOK_REDIRECT=http://localhost:8000/auth/facebook/callback
```

6. Execute as migrações:
```bash
php artisan migrate
```

7. Inicie o servidor:
```bash
php artisan serve
```

8. Acesse a aplicação em `http://localhost:8000`

## Estrutura do Projeto

A aplicação segue a estrutura padrão do Laravel, com algumas pastas específicas:

- `app/Http/Controllers`: Controladores da aplicação
  - `Auth`: Controladores de autenticação
  - `PageController.php`: Gerenciamento de páginas do Facebook
  - `VideoController.php`: Gerenciamento de vídeos
  - `MetricsController.php`: Análise de métricas

- `app/Models`: Modelos Eloquent
  - `User.php`: Modelo de usuário com autenticação Facebook
  - `Page.php`: Modelo para páginas do Facebook
  - `Video.php`: Modelo para vídeos
  - `VideoMetric.php`: Modelo para métricas de vídeos
  - `AudienceSegment.php`: Modelo para segmentação de público
  - `Topic.php`: Modelo para temas
  - `VideoTopic.php`: Modelo para relação entre vídeos e temas

- `resources/views`: Views da aplicação
  - `layouts`: Layouts base
  - `pages`: Views para páginas do Facebook
  - `videos`: Views para vídeos
  - `metrics`: Views para análise de métricas

## Permissões do Facebook

A aplicação requer as seguintes permissões do Facebook:
- `pages_read_engagement`: Para acessar páginas do usuário
- `read_insights`: Para acessar métricas e insights dos vídeos

## Implantação em Produção

Para instruções detalhadas sobre como implantar a aplicação em um ambiente de produção, consulte o arquivo [DEPLOYMENT.md](DEPLOYMENT.md).

## Uso da Aplicação

1. Faça login com sua conta do Facebook
2. Autorize as permissões necessárias
3. A aplicação importará automaticamente suas páginas do Facebook
4. Selecione uma página para importar seus vídeos
5. Explore as análises de métricas e público-alvo

## Tecnologias Utilizadas

- **Backend**: Laravel (PHP)
- **Frontend**: Bootstrap, Chart.js
- **Banco de Dados**: MySQL
- **Autenticação**: Laravel Socialite (OAuth)
- **API**: Facebook Graph API

## Licença

Este projeto está licenciado sob a licença MIT - veja o arquivo [LICENSE](LICENSE) para detalhes.

## Contato

Para suporte ou dúvidas, entre em contato através do email: suporte@exemplo.com
