<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('audience_segments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('video_id')->constrained()->onDelete('cascade');
            $table->string('segment_type'); // age, gender, location, etc.
            $table->string('segment_value');
            $table->integer('view_count')->default(0);
            $table->float('engagement_rate', 8, 2)->default(0);
            $table->timestamps();
            
            $table->index(['video_id', 'segment_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('audience_segments');
    }
};
